//+------------------------------------------------------------------+
//|                                                                  |
//|                                Copyright ?2012, Crisscross       |
//|                          Greenland 500 channel strategy REV2-3   |
//+------------------------------------------------------------------+
#property copyright "SI"
#property link      ""
#include <stdlib.mqh>
#include <stderror.mqh> 

// Input parameters
extern double Lots = 0;                   //If set to 0 then EA will calculate lot size according to risk percent
extern double Percent = 0.1;              //Enter percentage values (amount to be risked per lot)
extern double TP = 500;
extern double Dist = 100;
extern bool UseSL = false;
extern double SL = 0;
extern bool UsePrimerSL = false;
extern double PrimerSL = 0;
extern bool UseAutoPrimer = true;
extern double EquityDrop = 0.06;
extern double PrimerStep = 300;
extern double PrimerTP = 1000;
extern double PrimerLockin = 100;
extern double Slip = 30;

string Pair;
double EquityHigh, RecoveryEquity, NoOfBuy, NoOfSell, CurrentLotSize;
bool SetPrimer;
int BuyCount, SellCount;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
     GlobalVariablesDeleteAll();
     Pair = Symbol();
     SetPrimer=false;
     ReadEquityHigh();
     RecoveryEquity = AccountEquity();
     return(0);
  }
  
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
     return(0);
  }

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{
   int i;
   double Free = AccountBalance();
   double OneLot = MarketInfo(Pair,MODE_MARGINREQUIRED);
   double Step = MarketInfo(Pair,MODE_LOTSTEP);
   
   //Equity drop check
   if(UseAutoPrimer)
   {
      ReadEquityHigh();
      if(SetPrimer)
      {
         if(EquityHigh > RecoveryEquity)
            SetPrimer = false;
      }
      
      if(EquityHigh < AccountEquity()) 
      {
         EquityHigh = AccountEquity();
         WriteEquityHigh();
      }
      //Alert("EH= "+(EquityHigh)+" AE= "+AccountEquity());
      SetPrimer = CheckEquityDrop();
      if(SetPrimer)
         Alert(" SetPrimer: "+SetPrimer);
   }

   CurrentLotSize = (MathFloor(Free*Percent/100/OneLot/Step)*Step);
   CheckOpenPositions();
   //DeleteFarAwayPendingOrders();
   
   return(0);
}

//+------------------------------------------------------------------+
//|  CheckOpenPositions function                                     |
//+------------------------------------------------------------------+
void CheckOpenPositions()
{
   int cnt, total;
   NoOfBuy = 0;
   NoOfSell = 0;
   double TotalOpenLots = 0;
   double PrimerBuyLots, PrimerSellLots;
   double BuyOpenPrice, SellOpenPrice;
   int Count = 0;
   BuyCount = 0;
   SellCount = 0;

   total=OrdersTotal();
   
   if(total==0)
      OpenFirstTrade();
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if (OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_BUY ) 
         {
            Count++;
            if(OrderComment() == "Normal Buy")
            {
               BuyCount++;
               NoOfBuy=NoOfBuy+OrderLots();
               BuyOpenPrice = OrderOpenPrice();
               if(MathAbs(BuyOpenPrice - Ask)<(2*TP*Point))
               {
                  if(!SetPrimer)   
                     CheckBuyLevelPendingOrders(BuyOpenPrice);
               } 
            }       
         }
         if(OrderType() == OP_SELL ) 
         {
            Count++;
            if(OrderComment() == "Normal Sell")
            {
               SellCount++;
               NoOfSell=NoOfSell+OrderLots();
               SellOpenPrice = OrderOpenPrice();
               if(MathAbs(Bid - SellOpenPrice)<(2*TP*Point))
               {   
                  if(!SetPrimer)
                     CheckSellLevelPendingOrders(SellOpenPrice);
               } 
            }  
         }
      }
   }
   if(Count==0)
      OpenFirstTrade();
      
   //Alert("NOB= "+NoOfBuy+"NOS= "+NoOfSell);
   //TotalOpenLots = NoOfBuy+NoOfSell;
   
   if(SetPrimer)
   {
      //Alert("SetPrimers");
      if((SellCount > BuyCount))
      {
         //Alert("BP");
         PrimerBuyLots = FindBuyPrimerSize();
         CheckBuyPrimerOrders(NoOfBuy, BuyCount, PrimerBuyLots);
      }   
      if((BuyCount > SellCount))
      {
         //Alert("SP");
         PrimerSellLots = FindSellPrimerSize();
         CheckSellPrimerOrders(NoOfSell, SellCount, PrimerSellLots);
      }   
   }   
   
   return(0);
}

//+------------------------------------------------------------------+
//|  OpenFirstTrade function                                         |
//+------------------------------------------------------------------+
void OpenFirstTrade()
{
   Alert("test");
   int cnt, total, TicketNumberBuy1, TicketNumberSell1;
   double TProfit, SLoss;
   double BuyOpenPrice, SellOpenPrice;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;

   if(Lots==0)
   {
      double LotsNew = CurrentLotSize;
   }
   else
      LotsNew = Lots;
   
   total=OrdersTotal();
   
         TicketNumberBuy1 = OrderSend(Pair,OP_BUY,LotsNew,Ask,Slip,0,0,"Normal Buy");
         TicketNumberSell1 = OrderSend(Pair,OP_SELL,LotsNew,Bid,Slip,0,0,"Normal Sell");
         
         if(OrderSelect(TicketNumberBuy1,SELECT_BY_TICKET)==true)
         {
            TProfit = OrderOpenPrice() + TP*Point;
            if(UseSL)
            {
               SLoss = OrderOpenPrice() - Spread - SL*Point;
            }
            else
            {
               SLoss = SL;
            }
            if(OrderModify(OrderTicket(),OrderOpenPrice(),SLoss,TProfit,0,0)==true)
            {
            }
            else
            Alert("Error modifying BuyTrade= "+GetLastError());
         }
         if(OrderSelect(TicketNumberSell1,SELECT_BY_TICKET)==true)
         {
            TProfit = OrderOpenPrice() - TP*Point;
            if(UseSL)
            {
               SLoss = OrderOpenPrice() + Spread + SL*Point;
            }
            else
            {
               SLoss = SL;
            }
            if(OrderModify(OrderTicket(),OrderOpenPrice(),SLoss,TProfit,0,0)==true)
            {
            }
            else
            Alert("Error modifying SellTrade= "+GetLastError());
         }
}

//+------------------------------------------------------------------+
//|  ReadEquityHigh function                                         |
//+------------------------------------------------------------------+
void ReadEquityHigh()
{
   if(GlobalVariableCheck("AccEquityHigh"))
   {
      EquityHigh = GlobalVariableGet("AccEquityHigh");
   }
   else
   {
      EquityHigh = AccountEquity();
      GlobalVariableSet("AccEquityHigh",EquityHigh);
   }
}

//+------------------------------------------------------------------+
//|  WriteEquityHigh function                                        |
//+------------------------------------------------------------------+
void WriteEquityHigh()
{
   if(GlobalVariableSet("AccEquityHigh",EquityHigh)>0)
   {
      Alert("New balance written to file: ", EquityHigh);
   } 
   else 
      Alert("Error writing BalanceHigh: ",GetLastError());
}

//+------------------------------------------------------------------+
//|  CheckBuyLevelPendingOrders function                             |
//+------------------------------------------------------------------+
void CheckBuyLevelPendingOrders(double BOP)
{
   double NOP1;
   double BL = 0;
   double SL = 0;
   double NewLots = CurrentLotSize;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   bool OpenNewBuyTrade1, OpenNewSellTrade1;
   
   NOP1 = BOP+(TP*Point);
   //Alert("NOP1: "+NOP1);
   OpenNewBuyTrade1 = true;
   if((Bid-BOP)>(Dist*Point))
      OpenNewSellTrade1 = true;
   else
       OpenNewSellTrade1 = false;
   
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
      if(OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_BUY||OrderType() == OP_BUYSTOP||OrderType() == OP_BUYLIMIT) 
         {
            if(MathAbs(OrderOpenPrice()-NOP1)<(Spread+Slip*Point))
            {
               if(OrderLots() == CurrentLotSize)
                  OpenNewBuyTrade1=false;
               if(OrderLots() < CurrentLotSize)
               {
                  BL = BL + OrderLots();
               }
            }
         } 
         if(OrderType() == OP_SELL||OrderType() == OP_SELLSTOP||OrderType() == OP_SELLLIMIT)
         {
            if(MathAbs(OrderOpenPrice()-BOP)<(Spread+Slip*Point))
            {
               if(OrderLots() == CurrentLotSize)
                  OpenNewSellTrade1=false;
               if(OrderLots() < CurrentLotSize)
               {
                  SL = SL + OrderLots();
               }
            }
         }
      }
   }   
   if(OpenNewBuyTrade1)
   {
      if(BL < CurrentLotSize)
      {
         NewLots = CurrentLotSize - BL;
         OpenBuyPendingOrder((NOP1+Spread), NewLots);
      }   
   }
   if(OpenNewSellTrade1)
   {
      if(SL < CurrentLotSize)
      {
         NewLots = CurrentLotSize - SL;
         OpenSellPendingOrder((BOP - Spread),NewLots);
      }
   }
}


//+------------------------------------------------------------------+
//|  CheckSellLevelPendingOrders function                            |
//+------------------------------------------------------------------+
void CheckSellLevelPendingOrders(double SOP)
{
   double NOP2;
   double BL = 0;
   double SL = 0;
   double NewLots = CurrentLotSize;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   bool OpenNewBuyTrade2, OpenNewSellTrade2;

   NOP2 = SOP-TP*Point;
   //Alert("NOP2: "+NOP2);
   OpenNewSellTrade2 = true;
   if((SOP-Ask)>(Dist*Point))
      OpenNewBuyTrade2 = true;
   else
      OpenNewBuyTrade2 = false;
      
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if (OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_BUY||OrderType() == OP_BUYSTOP||OrderType() == OP_BUYLIMIT) 
         {
            if(MathAbs(SOP-OrderOpenPrice())<(Spread+Slip*Point))
            {
               if(OrderLots() == CurrentLotSize)
                  OpenNewBuyTrade2=false;
               if(OrderLots() < CurrentLotSize)
               {
                  BL = BL + OrderLots();
               }
            }
         } 
         if(OrderType() == OP_SELL||OrderType() == OP_SELLSTOP||OrderType() == OP_SELLLIMIT)
         {
            if(MathAbs(NOP2-OrderOpenPrice())<(Spread+Slip*Point))
            {
               if(OrderLots() == CurrentLotSize)
                  OpenNewSellTrade2=false;
               if(OrderLots() < CurrentLotSize)
               {
                  SL = SL + OrderLots();
               }
            }
         }
      }
   }   
   if(OpenNewBuyTrade2)
   {
      if(BL < CurrentLotSize)
      {
         NewLots = CurrentLotSize - BL;
         OpenBuyPendingOrder((SOP+Spread), NewLots);
      }   
   }
   if(OpenNewSellTrade2)
   {
      if(SL < CurrentLotSize)
      {
         NewLots = CurrentLotSize - SL;
         OpenSellPendingOrder((NOP2-Spread), NewLots);
      }   
   }
}

//+------------------------------------------------------------------+
//|  OpenBuyPendingOrder function                                    |
//+------------------------------------------------------------------+
void OpenBuyPendingOrder(double OpenPrice, double LS)
{
   int BuyOrderTicket;
   double SLoss, TProfit, LotsNew;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   int signal;
   if((OpenPrice-Ask) > 0)
   {
      signal = 4;
   }
   else
   {
      signal = 2;
   }
  
   if(Lots==0)
   {
      LotsNew = LS;
   }
   else
      LotsNew = Lots;
   
   Alert("Currentl Lot size: "+CurrentLotSize);
   BuyOrderTicket = OrderSend(Pair,signal,LotsNew,OpenPrice,Slip,0,0,"Normal Buy");
   
   if(OrderSelect(BuyOrderTicket,SELECT_BY_TICKET)==true)
   {
      TProfit = OpenPrice + (TP*Point);
      if(UseSL)
      {
         SLoss = OpenPrice - Spread - SL*Point;
      }
      else
      {
         SLoss = SL;
      }
      if(OrderModify(BuyOrderTicket,OpenPrice,SLoss,TProfit,0,0)==true)
      {
      }
      else
      Alert("Error modifying Buyorder= "+GetLastError());
   }
}

//+------------------------------------------------------------------+
//|  OpenSellPendingOrder function                                   |
//+------------------------------------------------------------------+
void OpenSellPendingOrder(double OpenPrice, double LS)
{
   int SellOrderTicket;
   double SLoss, TProfit, LotsNew;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   int signal;
  
   if((OpenPrice-Bid) > 0)
   {
      signal = 3;
   }
   else
   {
      signal = 5;
   }
   if(Lots==0)
   {
      LotsNew = LS;
   }
   else
      LotsNew = Lots;
   
   Alert("Currentl Lot size: "+CurrentLotSize);
   SellOrderTicket = OrderSend(Pair,signal,LotsNew,OpenPrice,Slip,0,0,"Normal Sell");
   
   if(OrderSelect(SellOrderTicket,SELECT_BY_TICKET)==true)
   {
      TProfit = OpenPrice - (TP*Point);
      if(UseSL)
      {
         SLoss = OpenPrice + Spread + (SL*Point);
      }
      else
      {
         SLoss = SL;
      }
      if(OrderModify(SellOrderTicket,OpenPrice,SLoss,TProfit,0,0)==true)
      {
      }
      else
      Alert("Error modifying Sellorder= "+GetLastError());
   }
}

//+------------------------------------------------------------------+
//|  DeleteFarAwayPendingOrders function                             |
//+------------------------------------------------------------------+
void DeleteFarAwayPendingOrders()
{
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if (OrderSymbol() == Symbol())
      {
         if(OrderType()==OP_BUYSTOP)
         {
            if((OrderOpenPrice()-Ask)>(10*TP*Point))
            {
               OrderDelete(OrderTicket());
            }
         }
         if(OrderType()==OP_BUYLIMIT)
         {
            if((Ask-OrderOpenPrice())>(10*TP*Point))
            {
               OrderDelete(OrderTicket());
            }
         }
         if(OrderType()==OP_SELLLIMIT)
         {
            if((OrderOpenPrice()-Bid)>(10*TP*Point))
            {
               OrderDelete(OrderTicket());
            }
         }
         if(OrderType()==OP_SELLSTOP)
         {
            if((Bid-OrderOpenPrice())>(10*TP*Point))
            {
               OrderDelete(OrderTicket());
            }
         }
      }
   }
}


//+------------------------------------------------------------------+
//|  CheckBuyPrimerOrders function                                   |
//+------------------------------------------------------------------+
void CheckBuyPrimerOrders(double TBL, double TBO, double LotSize)
{
   double BOP, NOP1;
   double LSOP = 0;
   double LBOP = 0;
   bool OpenNewSellTrade = true;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   double StopLevel = MarketInfo(Symbol(), MODE_STOPLEVEL);
   int CountBP;
   
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if ( OrderSymbol() == Symbol())
      {
         if(OrderComment() == "Primer Buy")
         {
            CountBP++;
            if(OrderType()==OP_BUY)
            {
               NOP1 = OrderOpenPrice() + PrimerStep*Point;
               OpenBuyPrimerOrder(NOP1, LotSize);   
            }
         }
      }
   }
   if(CountBP==0)
   {
      OpenBuyPrimerOrder(0, LotSize);
   }
   //Place Sell Stop orders 100 pips below
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if( OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_SELL||OrderType() == OP_SELLSTOP)
         {
            if(OrderOpenPrice()>LSOP)
            {
               //Alert("test");
               LSOP = OrderOpenPrice();
            }
         }
      }
   }
   double NSS = LSOP + TP*Point;
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if( OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_SELL||OrderType() == OP_SELLSTOP||OrderType() == OP_SELLLIMIT) 
         {
            if(MathAbs(OrderOpenPrice()-NSS)<(Spread+Slip*Point))
            {
               OpenNewSellTrade=false;
            }
         } 
      }
   } 
   if(OpenNewSellTrade)
   {
      if((Ask - NSS)>1000*Point)
         OpenSellPendingOrder(NSS, CurrentLotSize);
   }
   ModifyBuyPrimers();
   return(0);
}

//+------------------------------------------------------------------+
//|  OpenBuyPrimerOrder function                                     |
//+------------------------------------------------------------------+
void OpenBuyPrimerOrder(double BPOP, double BPL)
{
   int BuyOrderTicket1, BuyOrderTicket2;
   double BPOP2, SLoss, TProfit;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   bool OpenNewBuyPrimer1 = true;
   bool OpenNewBuyPrimer2 = true;
   if(BPOP == 0)
   {
      BuyOrderTicket1 = OrderSend(Pair,OP_BUY,BPL,Ask,Slip,0,0,"Primer Buy");
      
      if(OrderSelect(BuyOrderTicket1,SELECT_BY_TICKET)==true)
      {
         TProfit = OrderOpenPrice() + (PrimerTP*Point);
         if(UsePrimerSL)
         {
            SLoss = OrderOpenPrice() - Spread - PrimerSL*Point;
         }
         else
            SLoss = 0;
         
         if(OrderModify(BuyOrderTicket1,OrderOpenPrice(),SLoss,TProfit,0,0)==true)
         {
         }
         else
            Alert("Error modifying BuyPrimerOrder= "+GetLastError());
      }
      return(0);
   }
        
   if(BPOP!=0)
   {
   BPOP2 = BPOP + PrimerStep*Point;
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if ( OrderSymbol() == Symbol())
      {
         if(OrderComment()=="Primer Buy")
         {
            if(OrderType() == OP_BUY||OrderType() == OP_BUYSTOP||OrderType() == OP_BUYLIMIT)
            {
               if(MathAbs(OrderOpenPrice()-BPOP)<(Spread+Slip*Point))
               {
                  OpenNewBuyPrimer1 = false;
               }
               if(MathAbs(OrderOpenPrice()-BPOP2)<(Spread+Slip*Point))
               {
                  OpenNewBuyPrimer2 = false;
               }
            }
         }
      }
   }
   
   if(OpenNewBuyPrimer1)
   {
      BuyOrderTicket1 = OrderSend(Pair,OP_BUYSTOP,BPL,BPOP,Slip,0,0,"Primer Buy");
      
      if(OrderSelect(BuyOrderTicket1,SELECT_BY_TICKET)==true)
      {
         TProfit = OrderOpenPrice() + (PrimerTP*Point);
         if(UsePrimerSL)
         {
            SLoss = OrderOpenPrice() - Spread - PrimerSL*Point;
         }
         else
            SLoss = 0;
         
         if(OrderModify(BuyOrderTicket1,OrderOpenPrice(),SLoss,TProfit,0,0)==true)
         {
         }
         else
            Alert("Error modifying BuyPrimerOrder= "+GetLastError());
      }
      else
         Alert("Error placing BuyPrimerOrder= "+GetLastError()+" at: "+BPOP);
   }
   if(OpenNewBuyPrimer2)
   {
      BuyOrderTicket2 = OrderSend(Pair,OP_BUYSTOP,BPL,BPOP2,Slip,0,0,"Primer Buy");
      
      if(OrderSelect(BuyOrderTicket2,SELECT_BY_TICKET)==true)
      {
         TProfit = OrderOpenPrice() + (PrimerTP*Point);
         if(UsePrimerSL)
         {
            SLoss = OrderOpenPrice() - Spread - PrimerSL*Point;
         }
         else
            SLoss = 0;
         
         if(OrderModify(BuyOrderTicket2,OrderOpenPrice(),SLoss,TProfit,0,0)==true)
         {
         }
         else
            Alert("Error modifying BuyPrimerOrder2= "+GetLastError());
      }
      else
         Alert("Error placing BuyPrimerOrder2= "+GetLastError()+" at: "+BPOP);
   }
   }
   return(0);
}


//+------------------------------------------------------------------+
//|  CheckSellPrimerOrders function                                  |
//+------------------------------------------------------------------+
void CheckSellPrimerOrders(double TSL, double TSO, double LotSize)
{
   //Alert("SP");
   double SOP, NOP2;
   double LBOP = 10;
   double LSOP = 10;
   bool OpenNewBuyTrade = true;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   double StopLevel = MarketInfo(Symbol(), MODE_STOPLEVEL);
   int CountSP;
   
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if ( OrderSymbol() == Symbol())
      {
         if(OrderComment() == "Primer Sell")
         {
            CountSP++;
            Alert("Primer sell found");
            if(OrderType()==OP_SELL)
            {   
               NOP2 = OrderOpenPrice() - PrimerStep*Point;
               OpenSellPrimerOrder(NOP2, LotSize);
               Alert ("Open Sell Primer at: "+NOP2);
            }   
         }
      }
   }
   if(CountSP == 0)
   {
      OpenSellPrimerOrder(0, LotSize);
   }

   // Open Normal Buystops 100 pips above primers
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if( OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_BUY||OrderType()==OP_BUYSTOP) 
         {
            //Alert("test");
            if(OrderOpenPrice()<LBOP)
            {
               LBOP = OrderOpenPrice();
            }
         } 
      }
   }
   double NBS = LBOP - TP*Point;
   for(cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if( OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_BUY||OrderType() == OP_BUYSTOP||OrderType() == OP_BUYLIMIT) 
         {
            if(MathAbs(OrderOpenPrice()-NBS)<(Spread+Slip*Point))
            {
               OpenNewBuyTrade=false;
            }
         } 
      }
   } 
   if(OpenNewBuyTrade)
   {
      if((NBS-Bid)>1000*Point)
         OpenBuyPendingOrder(NBS, CurrentLotSize);
   }
   ModifySellPrimers();
   return(0);
}

//+------------------------------------------------------------------+
//|  OpenSellPrimerOrder function                                    |
//+------------------------------------------------------------------+
void OpenSellPrimerOrder(double SPOP, double SPL)
{
   int SellOrderTicket1, SellOrderTicket2;
   int CountSell;
   double SPOP2, SLoss, TProfit;
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   bool OpenNewSellPrimer1 = true;
   bool OpenNewSellPrimer2 = true;
   if(SPOP==0)
   {
      SellOrderTicket1 = OrderSend(Pair,OP_SELL,SPL,Bid,Slip,0,0,"Primer Sell");

      if(OrderSelect(SellOrderTicket1,SELECT_BY_TICKET)==true)
      {
         TProfit = OrderOpenPrice() - (PrimerTP*Point);
         if(UsePrimerSL)
         {
            SLoss = OrderOpenPrice() + Spread + PrimerSL*Point;
         }
         else
            SLoss = 0;
         
         if(OrderModify(SellOrderTicket1,OrderOpenPrice(),SLoss,TProfit,0,0)==true)
         {
         }
         else
            Alert("Error modifying SellPrimerOrder1= "+GetLastError());
      }
   }
   
   if(SPOP !=0)
   {
      SPOP2 = SPOP - PrimerStep*Point;
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if ( OrderSymbol() == Symbol())
      {
         if(OrderComment()=="Primer Sell")
         {
            if(OrderType() == OP_SELL||OrderType() == OP_SELLSTOP||OrderType() == OP_SELLLIMIT)
            {
               if(MathAbs(OrderOpenPrice()-SPOP)<(Spread+Slip*Point))
               {
                  OpenNewSellPrimer1 = false;
               }
               if(MathAbs(OrderOpenPrice()-SPOP2)<(Spread+Slip*Point))
               {
                  OpenNewSellPrimer2 = false;
               }
            }
         }
      }
   }
   if(OpenNewSellPrimer1 == true)
   {
      SellOrderTicket1 = OrderSend(Pair,OP_SELLSTOP,SPL,SPOP,Slip,0,0,"Primer Sell");

      if(OrderSelect(SellOrderTicket1,SELECT_BY_TICKET)==true)
      {
         TProfit = OrderOpenPrice() - (PrimerTP*Point);
         if(UsePrimerSL)
         {
            SLoss = OrderOpenPrice() + Spread + PrimerSL*Point;
         }
         else
            SLoss = 0;
         
         if(OrderModify(SellOrderTicket1,OrderOpenPrice(),SLoss,TProfit,0,0)==true)
         {
         }
         else
            Alert("Error modifying SellPrimerOrder1= "+GetLastError());
      }
      else
         Alert("Error placing SellPrimerOrder1= "+GetLastError()+" at: "+SPOP);
   }
   
   if(OpenNewSellPrimer2 == true)
   {
      SellOrderTicket2 = OrderSend(Pair,OP_SELLSTOP,SPL,SPOP2,Slip,0,0,"Primer Sell");

      if(OrderSelect(SellOrderTicket2,SELECT_BY_TICKET)==true)
      {
         TProfit = OrderOpenPrice() - (PrimerTP*Point);
         if(UsePrimerSL)
         {
            SLoss = OrderOpenPrice() + Spread + PrimerSL*Point;
         }
         else
            SLoss = 0;
         
         if(OrderModify(SellOrderTicket2,OrderOpenPrice(),SLoss,TProfit,0,0)==true)
         {
         }
         else
            Alert("Error modifying SellPrimerOrder2= "+GetLastError());
      }
      else
         Alert("Error placing SellPrimerOrder2= "+GetLastError()+" at: "+SPOP);
   }
   }
   return(0);
}

//+------------------------------------------------------------------+
//|  ModifyBuyPrimers function                                       |
//+------------------------------------------------------------------+
void ModifyBuyPrimers()
{
   double SLoss, NewSL; 
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if(OrderSymbol() == Symbol())
      {
         if(OrderComment()=="Primer Buy")
         {
            if(OrderType() == OP_BUY) 
            {
              if(OrderStopLoss()==0)
              {
                  if(Bid > (OrderOpenPrice()+2*PrimerStep*Point))
                  {
                     SLoss = OrderOpenPrice()+PrimerLockin*Point;
                     if(OrderModify(OrderTicket(),OrderOpenPrice(),SLoss,OrderTakeProfit(),0,0)==true)
                     {
                     }
                     else
                        GetLastError();
                  }
               }
               if(OrderStopLoss()!=0)
               {
                  if(Bid > (OrderOpenPrice()+3*PrimerStep*Point))
                  {
                     SLoss = OrderOpenPrice()+PrimerStep*Point+PrimerLockin*Point;
                     if(OrderModify(OrderTicket(),OrderOpenPrice(),SLoss,OrderTakeProfit(),0,0)==true)
                     {
                     }
                     else
                        GetLastError();
                  }   
               }
            }
         }    
      }
   }  
}

//+------------------------------------------------------------------+
//|  ModifySellPrimers function                                      |
//+------------------------------------------------------------------+
void ModifySellPrimers()
{
   double SLoss, NewSL; 
   double Spread = MarketInfo(Pair,MODE_SPREAD)*Point;
   
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if(OrderSymbol() == Symbol())
      {
         if(OrderComment()=="Primer Sell")
         {
            if(OrderType() == OP_SELL) 
            {
              if(OrderStopLoss()==0)
              {
                  if(Ask < (OrderOpenPrice()-2*PrimerStep*Point))
                  {
                    SLoss = OrderOpenPrice()-PrimerLockin*Point;
                     if(OrderModify(OrderTicket(),OrderOpenPrice(),SLoss,OrderTakeProfit(),0,0)==true)
                     {
                     }
                     else
                        GetLastError();
                  }
               }
               if(OrderStopLoss()!=0)
               {
                  if(Ask < (OrderOpenPrice()-3*PrimerStep*Point))
                  {
                     SLoss = OrderOpenPrice()-PrimerStep*Point-PrimerLockin*Point;
                     if(OrderModify(OrderTicket(),OrderOpenPrice(),SLoss,OrderTakeProfit(),0,0)==true)
                     {
                     }
                     else
                        GetLastError();
                  }   
               }
            }
         }    
      }
   }  
}

//+------------------------------------------------------------------+
//| FindBuyPrimerSize function                                       |
//+------------------------------------------------------------------+
double FindBuyPrimerSize()
{
   double PrimerSize;
   double BL=0;
   double SL=0;
   double Step = MarketInfo(Pair,MODE_LOTSTEP);
   double OneLot = MarketInfo(Pair,MODE_MARGINREQUIRED);
      
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if( OrderSymbol() == Symbol())
      {
         if(OrderType()==OP_BUY) 
         {
            if(OrderComment()=="Normal Buy")
               BL = BL + OrderLots();
         } 
         if(OrderType() == OP_SELL)
         {
            if(OrderComment()=="Normal Sell"||OrderComment()=="Primer Sell")
               SL = SL + OrderLots();
         }
      }
   }
   PrimerSize = MathFloor((SL - BL)/4/Step)*Step;
   Alert("BL = "+BL+" SL: "+SL+" Primersize ="+PrimerSize);
   return(PrimerSize);
}

//+------------------------------------------------------------------+
//| FindSellPrimerSize function                                      |
//+------------------------------------------------------------------+
double FindSellPrimerSize()
{
   double PrimerSize;
   double BL=0;
   double SL=0;
   double Step = MarketInfo(Pair,MODE_LOTSTEP);
   double OneLot = MarketInfo(Pair,MODE_MARGINREQUIRED);
      
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if( OrderSymbol() == Symbol())
      {
         if(OrderType()==OP_BUY) 
         {
            if(OrderComment()=="Normal Buy"||OrderComment()=="Primer Buy")
               BL = BL + OrderLots();
         } 
         if(OrderType() == OP_SELL)
         {
            if(OrderComment()=="Normal Sell")
               SL = SL + OrderLots();
         }
      }
   }
   PrimerSize = MathFloor((BL - SL)/3/Step)*Step;
   Alert("BL = "+BL+" SL: "+SL+" Primersize ="+PrimerSize);
   return(PrimerSize);
}


//+------------------------------------------------------------------+
//| CheckEquityDrop function                                         |
//+------------------------------------------------------------------+
bool CheckEquityDrop()
{
   
   double BL=0;
   double SL=0;
   bool ActivatePrimer = false;
         
   for(int cnt=OrdersTotal()-1;cnt>=0;cnt--)
   {
      OrderSelect (cnt, SELECT_BY_POS, MODE_TRADES);
      if( OrderSymbol() == Symbol())
      {
         if(OrderType() == OP_BUY) 
         {
            BL = BL + OrderLots();
         } 
         if(OrderType() == OP_SELL)
         {
            SL = SL + OrderLots();
         }
      }
   }
   Alert((((MathAbs(BL - SL)*10)/AccountBalance())*100));
   if((((MathAbs(BL - SL)*10)/AccountBalance())*100)>EquityDrop)
   {
      RecoveryEquity = EquityHigh;
      ActivatePrimer = true;
   }   
  return(ActivatePrimer);   
}